/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.options;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.crosswire.common.options.ArgumentType;
import org.crosswire.common.options.Option;
import org.crosswire.common.options.OptionList;

public class GetOptions {
    private String programName;
    private String[] args;
    private OptionList programOptions;
    private List nonOptionArgs;
    private Map suppliedOptions;

    public GetOptions(String programName, String[] args, OptionList programOptions) {
        this.programName = programName;
        this.args = args;
        this.programOptions = programOptions;
        this.nonOptionArgs = new ArrayList();
        this.suppliedOptions = new LinkedHashMap();
        this.parse();
    }

    private void parse() {
        int nargs = this.args.length;
        for (int i = 0; i < nargs; ++i) {
            String argument;
            Option option;
            String nextArg = this.args[i];
            if (nextArg.length() < 2 || nextArg.charAt(0) != '-') {
                this.nonOptionArgs.add(nextArg);
                continue;
            }
            if ("--".equals(nextArg)) {
                for (int j = i + 1; j < nargs; ++j) {
                    this.nonOptionArgs.add(this.args[j]);
                }
                return;
            }
            if (nextArg.charAt(1) == '-') {
                int equalPos = nextArg.indexOf(61);
                String flag = equalPos != -1 ? nextArg.substring(2, equalPos) : nextArg.substring(2);
                List opts = this.programOptions.getLongOptions(flag);
                if (opts.size() == 0) {
                    throw new IllegalArgumentException("Illegal option --" + flag);
                }
                if (opts.size() > 1) {
                    throw new IllegalArgumentException("Ambiguous option --" + flag);
                }
                option = (Option)opts.get(0);
                if (option.getArgumentType().equals(ArgumentType.NO_ARGUMENT)) {
                    this.suppliedOptions.put(option, null);
                    continue;
                }
                if (equalPos != -1) {
                    argument = equalPos + 1 < nextArg.length() ? nextArg.substring(equalPos + 1) : "";
                    this.suppliedOptions.put(option, argument);
                    continue;
                }
                if (!option.getArgumentType().equals(ArgumentType.REQUIRED_ARGUMENT)) continue;
                if (i + 1 < nargs) {
                    argument = this.args[i++];
                    this.suppliedOptions.put(option, argument);
                    continue;
                }
                throw new IllegalArgumentException("Option missing required argument");
            }
            int shortSeqSize = nextArg.length();
            for (int j = 1; j < shortSeqSize; ++j) {
                char curChar = nextArg.charAt(j);
                option = this.programOptions.getShortOption(curChar);
                if (option == null) {
                    throw new IllegalArgumentException("Illegal option -" + curChar);
                }
                if (option.getArgumentType().equals(ArgumentType.NO_ARGUMENT)) {
                    this.suppliedOptions.put(option, null);
                    continue;
                }
                if (j < shortSeqSize) {
                    argument = nextArg.substring(j + 1);
                    this.suppliedOptions.put(option, argument);
                    continue;
                }
                if (!option.getArgumentType().equals(ArgumentType.REQUIRED_ARGUMENT)) continue;
                if (i + 1 < nargs) {
                    argument = this.args[i++];
                    this.suppliedOptions.put(option, argument);
                    continue;
                }
                throw new IllegalArgumentException("Option missing required argument");
            }
        }
    }

    public static void swap(Object[] array, int firstStart, int firstEnd, int secondEnd) {
        int sourcePos = firstStart;
        int destPos = firstEnd + 1;
        int increment = 1;
        int destStop = secondEnd;
        int firstSize = firstEnd - firstStart + 1;
        int secondSize = secondEnd - firstEnd;
        int swapCount = secondSize + 1;
        if (firstSize > secondSize) {
            sourcePos = secondEnd;
            destPos = firstEnd;
            destStop = firstStart;
            increment = -1;
            swapCount = firstSize + 1;
        }
        if (firstSize == secondSize) {
            // empty if block
        }
        while (true) {
            int n = --swapCount;
            --swapCount;
            if (n <= 0) break;
            Object temp = array[destPos];
            array[destPos] = array[sourcePos];
            array[sourcePos] = temp;
            if (sourcePos != destStop) {
                sourcePos += increment;
            }
            if (destPos == destStop) continue;
            destPos += increment;
        }
    }
}

