/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.diff;

import org.crosswire.common.diff.Bitap;
import org.crosswire.common.diff.Locator;

public class Match
implements Locator {
    private String text;
    private String pattern;
    private int loc;
    private Locator locator;

    public Match() {
        this("", "", 0);
    }

    public Match(String text, String pattern, int loc) {
        this.text = text;
        this.pattern = pattern;
        this.loc = loc;
        this.locator = new Bitap(text, pattern, loc);
    }

    public int maxPatternLength() {
        return this.locator.maxPatternLength();
    }

    public int locate() {
        if (this.text.equals(this.pattern)) {
            return 0;
        }
        if (this.text.length() == 0) {
            return -1;
        }
        this.loc = Math.max(0, Math.min(this.loc, this.text.length() - this.pattern.length()));
        if (this.text.substring(this.loc, this.loc + this.pattern.length()).equals(this.pattern)) {
            return this.loc;
        }
        return this.locator.locate();
    }
}

