/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter.gbf;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.book.filter.FilterException;
import org.crosswire.jsword.book.filter.gbf.GBFTagBuilders;
import org.crosswire.jsword.book.filter.gbf.Tag;
import org.crosswire.jsword.passage.Key;
import org.jdom.Element;

public class GBFFilter
implements Filter {
    private static final String SEPARATORS = " ,:;.?!";
    static final /* synthetic */ boolean $assertionsDisabled;

    public List toOSIS(Book book, Key key, String plain) throws FilterException {
        DataPolice.setKey(key);
        Element ele = OSISUtil.factory().createDiv();
        LinkedList<Element> stack = new LinkedList<Element>();
        stack.addFirst(ele);
        List taglist = this.parseTags(book, key, plain.trim());
        while (!taglist.isEmpty()) {
            Tag tag = (Tag)taglist.remove(0);
            tag.updateOsisStack(stack);
        }
        stack.removeFirst();
        DataPolice.setKey(null);
        return ele.removeContent();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)e);
            }
            return null;
        }
    }

    private List parseTags(Book book, Key key, String aRemains) {
        String remains = aRemains;
        ArrayList<Tag> taglist = new ArrayList<Tag>();
        while (true) {
            Tag reply;
            String tag;
            int length;
            int ltpos = remains.indexOf(60);
            int gtpos = remains.indexOf(62);
            if (ltpos == -1 && gtpos == -1) {
                taglist.add(GBFTagBuilders.getTextTag(remains));
                remains = null;
                break;
            }
            if (ltpos == -1 || gtpos == -1) {
                DataPolice.report("In " + book.getInitials() + "(" + key.getName() + ") ignoring unmatched '<' or '>' in gbf: " + remains);
                taglist.add(GBFTagBuilders.getTextTag(remains));
                remains = null;
                break;
            }
            if (ltpos > gtpos) {
                DataPolice.report("In " + book.getInitials() + "(" + key.getName() + ") ignoring transposed '<' or '>' in gbf: " + remains);
                taglist.add(GBFTagBuilders.getTextTag(remains));
                remains = null;
                break;
            }
            String start = remains.substring(0, ltpos);
            int strLen = start.length();
            if (strLen > 0) {
                int beginIndex = 0;
                boolean inSepStr = SEPARATORS.indexOf(start.charAt(0)) >= 0;
                for (int i = 1; inSepStr && i < strLen; ++i) {
                    char currentChar = start.charAt(i);
                    if (SEPARATORS.indexOf(currentChar) >= 0) continue;
                    taglist.add(GBFTagBuilders.getTextTag(start.substring(beginIndex, i)));
                    beginIndex = i;
                    inSepStr = false;
                }
                if (beginIndex < strLen) {
                    taglist.add(GBFTagBuilders.getTextTag(start.substring(beginIndex)));
                }
            }
            if ((length = (tag = remains.substring(ltpos + 1, gtpos)).length()) > 0 && (reply = GBFTagBuilders.getTag(book, key, tag)) != null) {
                taglist.add(reply);
            }
            remains = remains.substring(gtpos + 1);
        }
        return taglist;
    }

    static {
        $assertionsDisabled = !GBFFilter.class.desiredAssertionStatus();
    }
}

