/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.aqua;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import org.crosswire.common.swing.Actionable;

public class OSXAdapter
extends ApplicationAdapter {
    private static OSXAdapter theAdapter;
    private static Application theApplication;
    private Actionable actionable;
    private String aboutAction;
    private String prefAction;
    private String quitAction;

    private OSXAdapter(Actionable actionable, String aboutAction, String prefAction, String quitAction) {
        this.actionable = actionable;
        this.aboutAction = aboutAction;
        this.prefAction = prefAction;
        this.quitAction = quitAction;
    }

    public static void registerMacOSXApplication(Actionable actionable, String aboutAction, String prefAction, String quitAction) {
        if (theApplication == null) {
            theApplication = new Application();
        }
        if (theAdapter == null) {
            theAdapter = new OSXAdapter(actionable, aboutAction, prefAction, quitAction);
        }
        theApplication.addApplicationListener((ApplicationListener)theAdapter);
    }

    public static void enablePrefs(boolean enabled) {
        if (theApplication == null) {
            theApplication = new Application();
        }
        theApplication.setEnabledPreferencesMenu(enabled);
    }

    public void handleAbout(ApplicationEvent ae) {
        this.handle(this.aboutAction, ae, true);
    }

    public void handlePreferences(ApplicationEvent ae) {
        this.handle(this.prefAction, ae, true);
    }

    public void handleQuit(ApplicationEvent ae) {
        this.handle(this.quitAction, ae, false);
    }

    private void handle(String action, ApplicationEvent ae, boolean handledState) {
        if (this.actionable == null) {
            throw new IllegalStateException("handleQuit: MyApp instance detached from listener");
        }
        ae.setHandled(handledState);
        this.actionable.actionPerformed(action);
        ae.setHandled(handledState);
    }
}

