/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.jsword.util.WebWarning;

public class InternetWarning
extends JPanel {
    public static final int GRANTED = 0;
    public static final int DENIED = 1;
    private transient ActionFactory actions = new ActionFactory(InternetWarning.class, (Object)this);
    protected int choice;
    protected JDialog dialog;
    protected JCheckBox showWarning;
    private static final long serialVersionUID = 3978992071925250097L;

    public InternetWarning() {
        ItemListener changer = new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                InternetWarning.this.fireStateChange();
            }
        };
        this.setLayout(new GridLayout(2, 1, 5, 5));
        this.add(new JLabel(WebWarning.instance().getWarning()));
        this.showWarning = new JCheckBox(WebWarning.instance().getShownWarningLabel());
        this.showWarning.setSelected(true);
        this.showWarning.addItemListener(changer);
        this.add(this.showWarning);
        GuiUtil.applyDefaultOrientation((Component)this);
    }

    public static int showDialog(Component parent, String title) {
        JDialog dialog;
        InternetWarning webWarning = new InternetWarning();
        JPanel buttons = new JPanel();
        JButton yesButton = new JButton(webWarning.actions.getAction("Yes"));
        JButton noButton = new JButton(webWarning.actions.getAction("No"));
        buttons.add(yesButton);
        buttons.add(noButton);
        Component root = SwingUtilities.getRoot(parent);
        webWarning.dialog = dialog = root instanceof JFrame ? new JDialog((JFrame)root, title, true) : new JDialog((JDialog)root, title, true);
        webWarning.choice = 1;
        dialog.getRootPane().setDefaultButton(yesButton);
        Container content = dialog.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)webWarning, "North");
        content.add((Component)buttons, "South");
        dialog.pack();
        GuiUtil.centerWindow((Window)dialog);
        GuiUtil.applyDefaultOrientation((Component)dialog);
        dialog.setVisible(true);
        dialog.dispose();
        return webWarning.choice;
    }

    public void doYes() {
        this.dialog.setVisible(false);
        this.choice = 0;
    }

    public void doNo() {
        this.dialog.setVisible(false);
        this.choice = 1;
    }

    protected void fireStateChange() {
        WebWarning.instance().setShown(this.showWarning.isSelected());
    }
}

