/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.io.Reader;
import org.apache.lucene.analysis.LowerCaseTokenizer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.crosswire.jsword.index.lucene.analysis.AbstractAnalyzer;

public class GermanLuceneAnalyzer
extends AbstractAnalyzer {
    public TokenStream tokenStream(String fieldName, Reader reader) {
        LowerCaseTokenizer result = new LowerCaseTokenizer(reader);
        if (this.doStopWords && this.stopSet != null) {
            result = new StopFilter((TokenStream)result, this.stopSet);
        }
        if (this.doStemming) {
            result = new GermanStemFilter((TokenStream)result);
        }
        return result;
    }

    public GermanLuceneAnalyzer() {
        this.stopSet = StopFilter.makeStopSet((String[])GermanAnalyzer.GERMAN_STOP_WORDS);
        this.setNaturalLanguage("German");
    }
}

