/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.icu.DateFormatter;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.sword.AbstractKeyBackend;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.DataEntry;
import org.crosswire.jsword.book.sword.DataIndex;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.UserMsg;
import org.crosswire.jsword.passage.DefaultLeafKeyList;
import org.crosswire.jsword.passage.Key;

public class RawLDBackend
extends AbstractKeyBackend {
    private static final int OFFSETSIZE = 4;
    private boolean active;
    private int datasize;
    private int entrysize;
    private int size = -1;
    private File idxFile;
    private RandomAccessFile idxRaf;
    private File datFile;
    private RandomAccessFile datRaf;
    private static final MessageFormat DATE_KEY_FORMAT;
    private static final Pattern STRONGS_PATTERN;
    private static final DecimalFormat ZERO_5PAD;
    private static final DecimalFormat ZERO_4PAD;
    private static final long serialVersionUID = 818089833394450383L;
    private static final Logger log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RawLDBackend(SwordBookMetaData sbmd, int datasize) {
        super(sbmd);
        this.datasize = datasize;
        this.entrysize = 4 + datasize;
    }

    public String getRawText(Key key) throws BookException {
        return this.getRawText(key.getName());
    }

    public String getRawText(String key) throws BookException {
        if (!this.checkActive()) {
            return "";
        }
        try {
            int pos = this.search(key);
            if (pos >= 0) {
                DataEntry entry = this.getEntry(key, pos);
                if (entry.isLinkEntry()) {
                    return this.getRawText(entry.getLinkTarget());
                }
                return this.getRawText(entry);
            }
            throw new BookException((MsgBase)UserMsg.READ_FAIL, new Object[]{key});
        }
        catch (IOException ex) {
            throw new BookException(UserMsg.READ_FAIL, ex, new Object[]{key});
        }
    }

    protected String getRawText(DataEntry entry) {
        String cipherKeyString = (String)this.getBookMetaData().getProperty(ConfigEntryType.CIPHER_KEY);
        return entry.getRawText(cipherKeyString != null ? cipherKeyString.getBytes() : null);
    }

    public int getCardinality() {
        if (!this.checkActive()) {
            return 0;
        }
        if (this.size == -1) {
            try {
                this.size = (int)(this.idxRaf.length() / (long)this.entrysize);
            }
            catch (IOException e) {
                this.size = 0;
            }
        }
        return this.size;
    }

    public Key get(int index) {
        if (this.checkActive()) {
            try {
                if (index < this.getCardinality()) {
                    DataEntry entry = this.getEntry(this.getBookMetaData().getInitials(), index);
                    String keytitle = this.internal2external(entry.getKey());
                    return new DefaultLeafKeyList(keytitle);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public int indexOf(Key that) {
        try {
            return this.search(that.getName());
        }
        catch (IOException e) {
            return -this.getCardinality() - 1;
        }
    }

    public void activate(Lock lock) {
        this.active = false;
        this.size = -1;
        this.idxFile = null;
        this.datFile = null;
        this.idxRaf = null;
        this.datRaf = null;
        URI path = null;
        try {
            path = this.getExpandedDataPath();
        }
        catch (BookException e) {
            Reporter.informUser((Object)this, (LucidException)e);
            return;
        }
        try {
            this.idxFile = new File(path.getPath() + ".idx");
            this.datFile = new File(path.getPath() + ".dat");
            if (!this.idxFile.canRead()) {
                Reporter.informUser((Object)this, (LucidException)new BookException((MsgBase)UserMsg.READ_FAIL, new Object[]{this.idxFile.getAbsolutePath()}));
                return;
            }
            if (!this.datFile.canRead()) {
                Reporter.informUser((Object)this, (LucidException)new BookException((MsgBase)UserMsg.READ_FAIL, new Object[]{this.datFile.getAbsolutePath()}));
                return;
            }
            this.idxRaf = new RandomAccessFile(this.idxFile, "r");
            this.datRaf = new RandomAccessFile(this.datFile, "r");
        }
        catch (IOException ex) {
            log.error("failed to open files", (Throwable)ex);
            this.idxRaf = null;
            this.datRaf = null;
            return;
        }
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(Lock lock) {
        this.size = -1;
        try {
            if (this.idxRaf != null) {
                this.idxRaf.close();
            }
            if (this.datRaf != null) {
                this.datRaf.close();
            }
        }
        catch (IOException ex) {
            log.error("failed to close files", (Throwable)ex);
        }
        finally {
            this.idxRaf = null;
            this.datRaf = null;
        }
        this.active = false;
    }

    protected boolean checkActive() {
        if (!this.isActive()) {
            Activator.activate((Activatable)this);
        }
        return this.isActive();
    }

    protected boolean isActive() {
        return this.active;
    }

    private DataIndex getIndex(long entry) throws IOException {
        byte[] buffer = SwordUtil.readRAF(this.idxRaf, entry * (long)this.entrysize, this.entrysize);
        int entryOffset = SwordUtil.decodeLittleEndian32(buffer, 0);
        int entrySize = -1;
        switch (this.datasize) {
            case 2: {
                entrySize = SwordUtil.decodeLittleEndian16(buffer, 4);
                break;
            }
            case 4: {
                entrySize = SwordUtil.decodeLittleEndian32(buffer, 4);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError(this.datasize);
                }
                break;
            }
        }
        return new DataIndex(entryOffset, entrySize);
    }

    private DataEntry getEntry(String reply, int index) throws IOException {
        DataIndex dataIndex = this.getIndex(index);
        byte[] data = SwordUtil.readRAF(this.datRaf, dataIndex.getOffset(), dataIndex.getSize());
        return new DataEntry(reply, data, this.getBookMetaData().getBookCharset());
    }

    private int search(String key) throws IOException {
        if (!this.checkActive()) {
            return -1;
        }
        String target = this.external2internal(key);
        int total = this.getCardinality();
        int low = -1;
        int high = total;
        while (high - low > 1) {
            int mid = low + high >>> 1;
            if (this.normalizeForSearch(this.getEntry(key, mid).getKey()).compareTo(target) < 0) {
                low = mid;
                continue;
            }
            high = mid;
        }
        if (high < total && this.normalizeForSearch(this.getEntry(key, high).getKey()).compareTo(target) == 0) {
            return high;
        }
        if (this.normalizeForSearch(this.getEntry(key, 0).getKey()).compareTo(target) == 0) {
            return 0;
        }
        return -(high + 1);
    }

    private String external2internal(String externalKey) {
        SwordBookMetaData bmd = this.getBookMetaData();
        String keytitle = externalKey;
        if (BookCategory.DAILY_DEVOTIONS.equals(bmd.getBookCategory())) {
            GregorianCalendar greg = new GregorianCalendar();
            DateFormatter nameDF = DateFormatter.getDateInstance();
            nameDF.setLenient(true);
            try {
                Date date = nameDF.parse(keytitle);
                greg.setTime(date);
                Object[] objs = new Object[]{new Integer(1 + greg.get(2)), new Integer(greg.get(5))};
                return DATE_KEY_FORMAT.format(objs);
            }
            catch (ParseException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)e);
                }
            }
        } else {
            if (bmd.hasFeature(FeatureType.GREEK_DEFINITIONS) || bmd.hasFeature(FeatureType.HEBREW_DEFINITIONS)) {
                Matcher m = STRONGS_PATTERN.matcher(keytitle);
                if (!m.matches()) {
                    return keytitle.toUpperCase(Locale.US);
                }
                int pos = keytitle.length() - 1;
                char lastLetter = keytitle.charAt(pos);
                boolean hasTrailingLetter = Character.isLetter(lastLetter);
                if (hasTrailingLetter) {
                    keytitle = keytitle.substring(0, pos);
                    if (--pos > 0 && keytitle.charAt(pos) == '!') {
                        keytitle = keytitle.substring(0, pos);
                    }
                }
                char type = keytitle.charAt(0);
                int strongsNumber = Integer.parseInt(keytitle.substring(1));
                if (bmd.hasFeature(FeatureType.GREEK_DEFINITIONS) && bmd.hasFeature(FeatureType.HEBREW_DEFINITIONS)) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(Character.toUpperCase(type));
                    buf.append(ZERO_4PAD.format(strongsNumber));
                    if (hasTrailingLetter && "naslex".equalsIgnoreCase(bmd.getInitials())) {
                        buf.append(Character.toUpperCase(lastLetter));
                    }
                    return buf.toString();
                }
                return ZERO_5PAD.format(strongsNumber);
            }
            return keytitle.toUpperCase(Locale.US);
        }
        return keytitle;
    }

    private String internal2external(String internalKey) {
        SwordBookMetaData bmd = this.getBookMetaData();
        String keytitle = internalKey;
        if (BookCategory.DAILY_DEVOTIONS.equals(bmd.getBookCategory()) && keytitle.length() >= 3) {
            GregorianCalendar greg = new GregorianCalendar();
            DateFormatter nameDF = DateFormatter.getDateInstance();
            String[] spec = StringUtil.splitAll((String)keytitle, (char)'.');
            greg.set(2, Integer.parseInt(spec[0]) - 1);
            greg.set(5, Integer.parseInt(spec[1]));
            keytitle = nameDF.format(greg.getTime());
        }
        return keytitle;
    }

    private String normalizeForSearch(String internalKey) {
        SwordBookMetaData bmd = this.getBookMetaData();
        String keytitle = internalKey;
        if (!BookCategory.DAILY_DEVOTIONS.equals(bmd.getBookCategory())) {
            return keytitle.toUpperCase(Locale.US);
        }
        return keytitle;
    }

    static {
        $assertionsDisabled = !RawLDBackend.class.desiredAssertionStatus();
        DATE_KEY_FORMAT = new MessageFormat("{0,number,00}.{1,number,00}");
        STRONGS_PATTERN = Pattern.compile("^([GH])(\\d+)((!)?([a-z])?)$");
        ZERO_5PAD = new DecimalFormat("00000");
        ZERO_4PAD = new DecimalFormat("0000");
        log = Logger.getLogger((Class)RawLDBackend.class);
    }
}

