/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.io.Reader;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.crosswire.jsword.index.lucene.analysis.AbstractAnalyzer;

public class ConfigurableSnowballAnalyzer
extends AbstractAnalyzer {
    private static Pattern allowedStemmers = Pattern.compile("(Danish|Dutch|English|Finnish|French|German2|German|Italian|Kp|Lovins|Norwegian|Porter|Portuguese|Russian|Spanish|Swedish)");
    private static HashMap defaultStopWordMap = new HashMap();
    private String stemmerName;

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        StandardTokenizer result = new StandardTokenizer(reader);
        result = new StandardFilter((TokenStream)result);
        result = new LowerCaseFilter((TokenStream)result);
        if (this.doStopWords && this.stopSet != null) {
            result = new StopFilter((TokenStream)result, this.stopSet);
        }
        if (this.doStemming) {
            result = new SnowballFilter((TokenStream)result, this.stemmerName);
        }
        return result;
    }

    public void setNaturalLanguage(String name) {
        this.naturalLanguage = name;
        this.stemmerName = name;
        if (!allowedStemmers.matcher(this.stemmerName).matches()) {
            throw new IllegalArgumentException("SnowballAnalyzer configured for unavailable stemmer " + this.stemmerName);
        }
        if (defaultStopWordMap.containsKey(name)) {
            this.stopSet = StopFilter.makeStopSet((String[])((String[])defaultStopWordMap.get(name)));
        }
    }

    static {
        defaultStopWordMap.put("French", FrenchAnalyzer.FRENCH_STOP_WORDS);
        defaultStopWordMap.put("German", GermanAnalyzer.GERMAN_STOP_WORDS);
        defaultStopWordMap.put("German2", GermanAnalyzer.GERMAN_STOP_WORDS);
        defaultStopWordMap.put("Dutch", DutchAnalyzer.DUTCH_STOP_WORDS);
        defaultStopWordMap.put("English", StopAnalyzer.ENGLISH_STOP_WORDS);
        defaultStopWordMap.put("Porter", StopAnalyzer.ENGLISH_STOP_WORDS);
    }
}

