/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.FileUtil;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.index.Index;
import org.crosswire.jsword.index.IndexManager;
import org.crosswire.jsword.index.IndexStatus;
import org.crosswire.jsword.index.lucene.LuceneIndex;
import org.crosswire.jsword.index.lucene.UserMsg;

public class LuceneIndexManager
implements IndexManager {
    protected static final Map INDEXES;
    private static final String DIR_LUCENE = "lucene";
    private static final Logger log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean isIndexed(Book book) {
        try {
            URI storage = this.getStorageArea(book);
            return NetUtil.isDirectory((URI)storage);
        }
        catch (IOException ex) {
            log.error("Failed to find lucene index storage area.", (Throwable)ex);
            return false;
        }
    }

    public Index getIndex(Book book) throws BookException {
        try {
            Index reply = (Index)INDEXES.get(book);
            if (reply == null) {
                URI storage = this.getStorageArea(book);
                reply = new LuceneIndex(book, storage);
                INDEXES.put(book, reply);
            }
            return reply;
        }
        catch (IOException ex) {
            throw new BookException((MsgBase)UserMsg.LUCENE_INIT, ex);
        }
    }

    public void scheduleIndexCreation(final Book book) {
        book.setIndexStatus(IndexStatus.SCHEDULED);
        Thread work = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                IndexStatus finalStatus = IndexStatus.UNDONE;
                try {
                    URI storage = LuceneIndexManager.this.getStorageArea(book);
                    LuceneIndex index = new LuceneIndex(book, storage, true);
                    if (NetUtil.getAsFile((URI)storage).exists()) {
                        finalStatus = IndexStatus.DONE;
                        INDEXES.put(book, index);
                    }
                }
                catch (IOException e) {
                    Reporter.informUser((Object)LuceneIndexManager.this, (Throwable)e);
                }
                catch (BookException e) {
                    Reporter.informUser((Object)LuceneIndexManager.this, (LucidException)e);
                }
                finally {
                    book.setIndexStatus(finalStatus);
                }
            }
        });
        work.start();
    }

    public void installDownloadedIndex(Book book, URI tempDest) throws BookException {
        try {
            URI storage = this.getStorageArea(book);
            File zip = NetUtil.getAsFile((URI)tempDest);
            IOUtil.unpackZip((File)zip, (File)NetUtil.getAsFile((URI)storage));
        }
        catch (IOException ex) {
            throw new BookException((MsgBase)UserMsg.INSTALL_FAIL, ex);
        }
    }

    public void deleteIndex(Book book) throws BookException {
        File tempPath = null;
        try {
            File storage = NetUtil.getAsFile((URI)this.getStorageArea(book));
            String finalCanonicalPath = storage.getCanonicalPath();
            tempPath = new File(finalCanonicalPath + '.' + IndexStatus.CREATING.toString());
            FileUtil.delete((File)tempPath);
            storage.renameTo(tempPath);
            book.setIndexStatus(IndexStatus.UNDONE);
        }
        catch (IOException ex) {
            throw new BookException((MsgBase)UserMsg.DELETE_FAILED, ex);
        }
        FileUtil.delete((File)tempPath);
    }

    protected URI getStorageArea(Book book) throws IOException {
        BookMetaData bmd = book.getBookMetaData();
        String driverName = bmd.getDriverName();
        String bookName = bmd.getInitials();
        if (!$assertionsDisabled && driverName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bookName == null) {
            throw new AssertionError();
        }
        URI base = CWProject.instance().getWriteableProjectSubdir(DIR_LUCENE, false);
        URI driver = NetUtil.lengthenURI((URI)base, (String)driverName);
        return NetUtil.lengthenURI((URI)driver, (String)bookName);
    }

    static {
        $assertionsDisabled = !LuceneIndexManager.class.desiredAssertionStatus();
        INDEXES = new HashMap();
        log = Logger.getLogger((Class)LuceneIndexManager.class);
    }
}

