/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.UserMsg;

public final class IOUtil {
    private static final Logger log = Logger.getLogger(IOUtil.class);

    private IOUtil() {
    }

    public static void unpackZip(File file, File destdir) throws IOException {
        byte[] dbuf = new byte[4096];
        ZipFile zf = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            int count;
            ZipEntry entry = entries.nextElement();
            String entrypath = entry.getName();
            File entryFile = new File(destdir, entrypath);
            File parentDir = entryFile.getParentFile();
            if (!parentDir.isDirectory()) {
                parentDir.mkdirs();
                if (!parentDir.isDirectory()) {
                    throw new MalformedURLException(UserMsg.CREATE_DIR_FAIL.toString(parentDir.toString()));
                }
            }
            URI child = NetUtil.getURI(entryFile);
            OutputStream dataOut = NetUtil.getOutputStream(child);
            InputStream dataIn = zf.getInputStream(entry);
            while ((count = dataIn.read(dbuf)) != -1) {
                dataOut.write(dbuf, 0, count);
            }
            dataOut.close();
        }
    }

    public static void close(RandomAccessFile raf) {
        if (null != raf) {
            try {
                raf.close();
            }
            catch (IOException ex) {
                log.error("close", ex);
            }
        }
    }

    public static void close(OutputStream out) {
        if (null != out) {
            try {
                out.close();
            }
            catch (IOException ex) {
                log.error("close", ex);
            }
        }
    }

    public static void close(InputStream in) {
        if (null != in) {
            try {
                in.close();
            }
            catch (IOException ex) {
                log.error("close", ex);
            }
        }
    }

    public static void close(Reader in) {
        if (null != in) {
            try {
                in.close();
            }
            catch (IOException ex) {
                log.error("close", ex);
            }
        }
    }
}

