/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.diff;

import org.crosswire.common.diff.CommonMiddle;

public class Commonality {
    static final /* synthetic */ boolean $assertionsDisabled;

    private Commonality() {
    }

    public static int prefix(String source, String target) {
        int pointermax;
        int pointermin = 0;
        int pointermid = pointermax = Math.min(source.length(), target.length());
        while (pointermin < pointermid) {
            if (source.regionMatches(0, target, 0, pointermid)) {
                pointermin = pointermid;
            } else {
                pointermax = pointermid;
            }
            pointermid = (pointermax - pointermin) / 2 + pointermin;
        }
        return pointermid;
    }

    public static int suffix(String source, String target) {
        int pointermax;
        int pointermin = 0;
        int pointermid = pointermax = Math.min(source.length(), target.length());
        while (pointermin < pointermid) {
            if (source.regionMatches(source.length() - pointermid, target, target.length() - pointermid, pointermid)) {
                pointermin = pointermid;
            } else {
                pointermax = pointermid;
            }
            pointermid = (pointermax - pointermin) / 2 + pointermin;
        }
        return pointermid;
    }

    public static CommonMiddle halfMatch(String source, String target) {
        int targetLength;
        int sourceLength = source.length();
        String longText = sourceLength > (targetLength = target.length()) ? source : target;
        String shortText = sourceLength > targetLength ? target : source;
        int longTextLength = Math.max(sourceLength, targetLength);
        if (longTextLength < 10 || shortText.length() < 1) {
            return null;
        }
        CommonMiddle hm1 = Commonality.halfMatch(longText, shortText, Commonality.ceil(longTextLength, 4));
        CommonMiddle hm2 = Commonality.halfMatch(longText, shortText, Commonality.ceil(longTextLength, 2));
        CommonMiddle hm = null;
        if (hm1 == null && hm2 == null) {
            return null;
        }
        if (hm2 == null) {
            hm = hm1;
        } else if (hm1 == null) {
            hm = hm2;
        } else {
            CommonMiddle commonMiddle = hm = hm1.getCommonality().length() > hm2.getCommonality().length() ? hm1 : hm2;
        }
        if (sourceLength > targetLength) {
            return hm;
        }
        return new CommonMiddle(hm.getTargetPrefix(), hm.getTargetSuffix(), hm.getSourcePrefix(), hm.getSourceSuffix(), hm.getCommonality());
    }

    private static int ceil(int number, int divisor) {
        if (!$assertionsDisabled && divisor <= 0) {
            throw new AssertionError();
        }
        int result = number / divisor + (number % divisor > 0 ? 1 : 0);
        return result;
    }

    private static CommonMiddle halfMatch(String longText, String shortText, int startIndex) {
        String seed = longText.substring(startIndex, startIndex + longText.length() / 4);
        int j = -1;
        String common = "";
        String longTextPrefix = "";
        String longTextSuffix = "";
        String shortTextPrefix = "";
        String shortTextSuffix = "";
        while ((j = shortText.indexOf(seed, j + 1)) != -1) {
            int prefixLength = Commonality.prefix(longText.substring(startIndex), shortText.substring(j));
            int suffixLength = Commonality.suffix(longText.substring(0, startIndex), shortText.substring(0, j));
            if (common.length() >= prefixLength + suffixLength) continue;
            common = shortText.substring(j - suffixLength, j) + shortText.substring(j, j + prefixLength);
            longTextPrefix = longText.substring(0, startIndex - suffixLength);
            longTextSuffix = longText.substring(startIndex + prefixLength);
            shortTextPrefix = shortText.substring(0, j - suffixLength);
            shortTextSuffix = shortText.substring(j + prefixLength);
        }
        if (common.length() >= longText.length() / 2) {
            return new CommonMiddle(longTextPrefix, longTextSuffix, shortTextPrefix, shortTextSuffix, common);
        }
        return null;
    }

    static {
        $assertionsDisabled = !Commonality.class.desiredAssertionStatus();
    }
}

