/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.compress;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import org.crosswire.common.compress.Compressor;
import org.crosswire.common.compress.LZSS;
import org.crosswire.common.compress.Zip;

public abstract class CompressorType
implements Serializable {
    public static final CompressorType ZIP;
    public static final CompressorType LZSS;
    private String name;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final CompressorType[] VALUES;
    private static final long serialVersionUID = 3256727260177708345L;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected CompressorType(String name) {
        this.name = name;
    }

    public abstract Compressor getCompressor(byte[] var1);

    public static CompressorType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            CompressorType o = VALUES[i];
            if (!o.name.equalsIgnoreCase(name)) continue;
            return o;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static CompressorType fromInteger(int i) {
        return VALUES[i];
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !CompressorType.class.desiredAssertionStatus();
        ZIP = new CompressorType("ZIP"){
            private static final long serialVersionUID = 7380833510438155782L;

            public Compressor getCompressor(byte[] input) {
                return new Zip(new ByteArrayInputStream(input));
            }
        };
        LZSS = new CompressorType("LZSS"){
            private static final long serialVersionUID = -5794644645111043930L;

            public Compressor getCompressor(byte[] input) {
                return new LZSS(new ByteArrayInputStream(input));
            }
        };
        VALUES = new CompressorType[]{ZIP, LZSS};
    }
}

