/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.ISOLatin1AccentFilter;
import org.apache.lucene.analysis.LowerCaseTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.crosswire.jsword.index.lucene.analysis.AbstractAnalyzer;

public class SimpleLuceneAnalyzer
extends AbstractAnalyzer {
    private static Pattern isoLatin1Langs = Pattern.compile("(Afrikaans|Albanian|Basque|Breton|Catalan|Danish|Dutch|English|Estonian|Faroese|French|Finnish|Galician|German|Icelandic|Irish|Italian|Latin|Luxembourgish|Norwegian|Occitan|Portuguese|Romansh|Scottish Gaelic|Spanish|Swahili|Swedish|Walloon)");

    public SimpleLuceneAnalyzer() {
        this.doStemming = false;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        LowerCaseTokenizer result = new LowerCaseTokenizer(reader);
        if (this.naturalLanguage != null && isoLatin1Langs.matcher(this.naturalLanguage).matches()) {
            result = new ISOLatin1AccentFilter((TokenStream)result);
        }
        return result;
    }
}

