/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter.thml;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.crosswire.common.util.Logger;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.book.filter.FilterException;
import org.crosswire.jsword.book.filter.thml.CustomHandler;
import org.crosswire.jsword.passage.Key;
import org.jdom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class THMLFilter
implements Filter {
    private String errorMessage;
    private Exception error;
    private String finalInput;
    private static final Logger log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public List toOSIS(Book book, Key key, String plain) throws FilterException {
        DataPolice.setKey(key);
        Element ele = this.cleanParse(book, key, plain);
        DataPolice.setKey(null);
        if (ele == null) {
            if (this.error instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)this.error;
                int colNumber = spe.getColumnNumber();
                int start = Math.max(0, colNumber - 40);
                int stop = Math.min(this.finalInput.length(), colNumber + 40);
                int here = stop - start;
                log.warn("Could not fix " + book.getInitials() + '(' + key.getName() + ") by " + this.errorMessage + ": Error here(" + colNumber + ',' + this.finalInput.length() + ',' + here + "): " + this.finalInput.substring(start, stop));
            } else {
                log.warn("Could not fix " + book.getInitials() + "(" + key.getName() + ") by " + this.errorMessage + ": " + this.error.getMessage());
            }
            ele = OSISUtil.factory().createP();
        }
        return ele.removeContent();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)e);
            }
            return null;
        }
    }

    private Element cleanParse(Book book, Key key, String plain) {
        String clean = XMLUtil.cleanAllEntities((String)plain);
        Element ele = this.parse(book, key, clean, "cleaning entities");
        if (ele == null) {
            ele = this.cleanText(book, key, clean);
        }
        return ele;
    }

    private Element cleanText(Book book, Key key, String plain) {
        String clean = XMLUtil.cleanAllCharacters((String)plain);
        Element ele = this.parse(book, key, clean, "cleaning text");
        if (ele == null) {
            ele = this.cleanTags(book, key, clean);
        }
        return ele;
    }

    private Element cleanTags(Book book, Key key, String plain) {
        String clean = XMLUtil.cleanAllTags((String)plain);
        return this.parse(book, key, clean, "cleaning tags");
    }

    private Element parse(Book book, Key key, String plain, String failMessage) {
        Exception ex = null;
        StringBuffer buf = new StringBuffer(15 + plain.length());
        buf.append('<').append("root").append('>').append(plain).append("</").append("root").append('>');
        this.finalInput = buf.toString();
        try {
            StringReader in = new StringReader(this.finalInput);
            InputSource is = new InputSource(in);
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser parser = spf.newSAXParser();
            CustomHandler handler = new CustomHandler(book, key);
            parser.parse(is, (DefaultHandler)handler);
            return handler.getRootElement();
        }
        catch (SAXParseException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        this.errorMessage = failMessage;
        this.error = ex;
        return null;
    }

    static {
        $assertionsDisabled = !THMLFilter.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)THMLFilter.class);
    }
}

