/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.basic;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.crosswire.common.util.Language;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.index.IndexStatus;
import org.jdom.Document;

public abstract class AbstractBookMetaData
implements BookMetaData {
    private Map prop = new LinkedHashMap();
    private BookDriver driver;
    private IndexStatus indexStatus = IndexStatus.UNDONE;

    public BookDriver getDriver() {
        return this.driver;
    }

    public String getDriverName() {
        if (this.getDriver() == null) {
            return null;
        }
        return this.getDriver().getDriverName();
    }

    public boolean hasFeature(FeatureType feature) {
        return false;
    }

    public String getOsisID() {
        return this.getBookCategory().getName() + '.' + this.getInitials();
    }

    public boolean isSupported() {
        return true;
    }

    public boolean isEnciphered() {
        return false;
    }

    public boolean isLocked() {
        return false;
    }

    public boolean unlock(String unlockKey) {
        return false;
    }

    public String getUnlockKey() {
        return null;
    }

    public boolean isQuestionable() {
        return false;
    }

    public Language getLanguage() {
        return (Language)this.getProperty("Lang");
    }

    public void setLanguage(Language language) {
        this.putProperty("Lang", language);
    }

    public URI getLibrary() {
        URI uri = null;
        try {
            String loc = (String)this.getProperty("LibraryURI");
            if (loc != null) {
                uri = new URI(loc);
            }
            return uri;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public void setLibrary(URI library) {
        this.putProperty("LibraryURI", library.toString());
    }

    public void setLocation(URI location) {
        this.putProperty("LocationURI", location.toString());
    }

    public URI getLocation() {
        URI uri = null;
        try {
            String loc = (String)this.getProperty("LocationURI");
            if (loc != null) {
                uri = new URI(loc);
            }
            return uri;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.prop);
    }

    public void setProperties(Map newProperties) {
        this.prop = newProperties;
    }

    public Object getProperty(String key) {
        return this.prop.get(key);
    }

    public void putProperty(String key, Object value) {
        this.prop.put(key, value);
    }

    public IndexStatus getIndexStatus() {
        return this.indexStatus;
    }

    public void setIndexStatus(IndexStatus newValue) {
        this.indexStatus = newValue;
        this.prop.put("IndexStatus", newValue.toString());
    }

    public Document toOSIS() {
        throw new UnsupportedOperationException("If you want to use this, implement it.");
    }

    public void setDriver(BookDriver driver) {
        this.driver = driver;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        BookMetaData that = (BookMetaData)obj;
        return this.getBookCategory().equals(that.getBookCategory()) && this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public int compareTo(Object obj) {
        int result = this.getBookCategory().compareTo(((BookMetaData)obj).getBookCategory());
        if (result == 0) {
            result = this.getName().compareTo(((BookMetaData)obj).getName());
        }
        return result;
    }

    public String toString() {
        return this.getInitials();
    }
}

