/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.ToStringUtils;

public abstract class MultiTermQuery
extends Query {
    private Term term;

    public MultiTermQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    protected abstract FilteredTermEnum getEnum(IndexReader var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query rewrite(IndexReader reader) throws IOException {
        FilteredTermEnum enumerator = this.getEnum(reader);
        BooleanQuery query = new BooleanQuery(true);
        try {
            do {
                Term t;
                if ((t = enumerator.term()) == null) continue;
                TermQuery tq = new TermQuery(t);
                tq.setBoost(this.getBoost() * enumerator.difference());
                query.add(tq, BooleanClause.Occur.SHOULD);
            } while (enumerator.next());
        }
        finally {
            enumerator.close();
        }
        return query;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiTermQuery)) {
            return false;
        }
        MultiTermQuery multiTermQuery = (MultiTermQuery)o;
        if (!this.term.equals(multiTermQuery.term)) {
            return false;
        }
        return this.getBoost() == multiTermQuery.getBoost();
    }

    public int hashCode() {
        return this.term.hashCode() + Float.floatToRawIntBits(this.getBoost());
    }
}

