/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.crosswire.bibledesktop.book.install.InstallManagerComboBoxModel;
import org.crosswire.bibledesktop.book.install.Msg;
import org.crosswire.common.swing.CWOptionPane;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.InstallManager;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.index.IndexManagerFactory;
import org.crosswire.jsword.util.IndexDownloader;

public final class IndexResolver {
    private static final Logger log;
    static final /* synthetic */ boolean $assertionsDisabled;

    private IndexResolver() {
    }

    public static void scheduleIndex(Book book, Component parent) {
        int choice = 1;
        switch (choice) {
            case 0: {
                Installer installer = IndexResolver.selectInstaller(parent);
                if (installer == null) break;
                Throwable ex = null;
                try {
                    IndexDownloader.downloadIndex((Book)book, (Installer)installer);
                }
                catch (InstallException e) {
                    ex = e;
                }
                catch (BookException e) {
                    ex = e;
                }
                catch (IOException e) {
                    ex = e;
                }
                if (ex == null) break;
                log.error("index download failed: ", ex);
                String gtitle = Msg.HOW_GENERATE_TITLE.toString();
                Msg gmsg = Msg.HOW_GENERATE;
                int yn = CWOptionPane.showConfirmDialog((Component)parent, (Object)((Object)gmsg), (String)gtitle, (int)0, (int)3);
                if (yn != 0) break;
                IndexManagerFactory.getIndexManager().scheduleIndexCreation(book);
                break;
            }
            case 1: {
                IndexManagerFactory.getIndexManager().scheduleIndexCreation(book);
                break;
            }
        }
    }

    private static Installer selectInstaller(Component parent) {
        InstallManager insman = new InstallManager();
        Map installers = insman.getInstallers();
        Installer installer = null;
        if (installers.size() == 1) {
            Iterator it = installers.values().iterator();
            boolean hasNext = it.hasNext();
            if (!$assertionsDisabled && !hasNext) {
                throw new AssertionError();
            }
            installer = (Installer)it.next();
        } else {
            JComboBox choice = new JComboBox(new InstallManagerComboBoxModel(insman));
            JLabel label = new JLabel(Msg.HOW_SITE.toString());
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)label, "North");
            panel.add(choice, "Center");
            String title = Msg.HOW_SITE_TITLE.toString();
            int yn = CWOptionPane.showConfirmDialog((Component)parent, (Object)panel, (String)title, (int)0);
            if (yn == 0) {
                installer = (Installer)choice.getSelectedItem();
            }
        }
        return installer;
    }

    static {
        $assertionsDisabled = !IndexResolver.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)IndexResolver.class);
    }
}

