/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.crosswire.bibledesktop.book.DisplaySelectPane;
import org.crosswire.bibledesktop.book.Msg;
import org.crosswire.bibledesktop.book.PassageSelectionPane;
import org.crosswire.common.icu.NumberShaper;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.jsword.index.search.SearchType;

public class AdvancedSearchPane
extends JPanel
implements DocumentListener {
    private static final String DONE = "Done";
    private static final String PHRASE = "Phrase";
    private static final String RESTRICT = "Restrict";
    private static final String HEAD_RANK = "HeadRank";
    private static final String RANK = "RankSomeSlider";
    private static final String HEAD_RESTRICT = "HeadRestrict";
    private static final String HEAD_BASE = "HeadBase";
    private static final String INCLUDES = "Includes";
    private static final String EXCLUDES = "Excludes";
    private static final String SPELL = "Spell";
    private static final String STARTS_WITH = "StartsWith";
    private static final String PRESETS = "Presets";
    private static final String RESTRICT_SELECT = "RestrictSelect";
    private static final String HEAD_SUMMARY = "HeadSummary";
    private static final String SUMMARY = "Summary";
    private static final String SPACE = " ";
    private String presetEnd;
    private String presetStart;
    protected boolean bailout;
    private transient ActionFactory actions;
    private NumberShaper shaper;
    private String[] presets = Msg.PRESETS.toString().split("\\|");
    private boolean editingRestrict;
    private PassageSelectionPane dlgSelect;
    private JLabel lblPhrase;
    private JLabel lblIncludes;
    private JTextField txtIncludes;
    private JTextField txtPhrase;
    private JLabel lblExcludes;
    private JTextField txtExcludes;
    private JLabel lblSpell;
    private JTextField txtSpell;
    private JLabel lblStartsWith;
    private JTextField txtStartsWith;
    private JLabel lblHeading;
    private JCheckBox chkRank;
    private JLabel lblRank;
    private JSlider sliderRank;
    private JCheckBox chkRestrict;
    private JLabel lblRestrict;
    private JTextField txtRestrict;
    private JButton btnRestrict;
    private JButton btnGo;
    private JLabel lblPresets;
    private JComboBox cboPresets;
    protected JDialog dlgMain;
    private JLabel lblSummary;
    private JCheckBox chkSummary;
    private JTextArea txtSummary;
    private JScrollPane scrSummary;
    private static final long serialVersionUID = 3977303234983245108L;

    public AdvancedSearchPane() {
        this.initialize();
    }

    private void initialize() {
        this.shaper = new NumberShaper();
        this.presetStart = Msg.PRESET_START.toString();
        this.presetEnd = Msg.PRESET_END.toString();
        this.actions = new ActionFactory(AdvancedSearchPane.class, (Object)this);
        JLabel temp = new JLabel();
        Color headBG = SystemColor.control.darker();
        Color headFG = Color.BLACK;
        Font headFont = temp.getFont().deriveFont(1);
        this.lblHeading = this.actions.createJLabel(HEAD_BASE);
        this.lblHeading.setBorder(BorderFactory.createLineBorder(headBG, 3));
        this.lblHeading.setBackground(headBG);
        this.lblHeading.setForeground(headFG);
        this.lblHeading.setFont(headFont);
        this.lblHeading.setOpaque(true);
        this.lblPhrase = this.actions.createJLabel(PHRASE);
        this.txtPhrase = new JTextField();
        this.txtPhrase.getDocument().addDocumentListener(this);
        this.txtIncludes = new JTextField();
        this.txtIncludes.getDocument().addDocumentListener(this);
        this.lblIncludes = this.actions.createJLabel(INCLUDES);
        this.lblIncludes.setLabelFor(this.txtIncludes);
        this.txtExcludes = new JTextField();
        this.txtExcludes.getDocument().addDocumentListener(this);
        this.lblExcludes = this.actions.createJLabel(EXCLUDES);
        this.lblExcludes.setLabelFor(this.txtExcludes);
        this.txtSpell = new JTextField();
        this.txtSpell.getDocument().addDocumentListener(this);
        this.lblSpell = this.actions.createJLabel(SPELL);
        this.lblSpell.setLabelFor(this.txtSpell);
        this.txtStartsWith = new JTextField();
        this.txtStartsWith.getDocument().addDocumentListener(this);
        this.lblStartsWith = this.actions.createJLabel(STARTS_WITH);
        this.lblStartsWith.setLabelFor(this.txtStartsWith);
        this.chkRank = new JCheckBox(this.actions.getAction(HEAD_RANK));
        this.chkRank.setBackground(headBG);
        this.chkRank.setForeground(headFG);
        this.chkRank.setFont(headFont);
        this.lblRank = this.actions.createJLabel(RANK);
        this.setLabelRank(DisplaySelectPane.getNumRankedVerses());
        this.lblRank.setVisible(false);
        this.sliderRank = new JSlider(0, 0, DisplaySelectPane.getMaxNumRankedVerses(), DisplaySelectPane.getNumRankedVerses());
        this.sliderRank.setMajorTickSpacing(DisplaySelectPane.getMaxNumRankedVerses() / 5);
        this.sliderRank.setMinorTickSpacing(DisplaySelectPane.getMaxNumRankedVerses() / 20);
        this.sliderRank.setLabelTable(this.createSliderLabels());
        this.sliderRank.setPaintTicks(true);
        this.sliderRank.setPaintLabels(true);
        this.sliderRank.setVisible(false);
        this.sliderRank.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int val = source.getValue();
                if (source.getValueIsAdjusting()) {
                    AdvancedSearchPane.this.setLabelRank(val);
                } else {
                    DisplaySelectPane.setNumRankedVerses(val);
                }
            }
        });
        this.chkRestrict = new JCheckBox(this.actions.getAction(HEAD_RESTRICT));
        this.chkRestrict.setBackground(headBG);
        this.chkRestrict.setForeground(headFG);
        this.chkRestrict.setFont(headFont);
        this.lblPresets = this.actions.createJLabel(PRESETS);
        this.lblPresets.setVisible(false);
        this.cboPresets = new JComboBox<String>(this.presets);
        this.cboPresets.setVisible(false);
        this.cboPresets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AdvancedSearchPane.this.updatePreset();
            }
        });
        this.lblRestrict = this.actions.createJLabel(RESTRICT);
        this.lblRestrict.setVisible(false);
        this.txtRestrict = new JTextField();
        this.txtRestrict.setVisible(false);
        this.txtRestrict.getDocument().addDocumentListener(this);
        this.btnRestrict = new JButton(this.actions.getAction(RESTRICT_SELECT));
        this.btnRestrict.setVisible(false);
        this.chkSummary = new JCheckBox(this.actions.getAction(HEAD_SUMMARY));
        this.chkSummary.setBackground(headBG);
        this.chkSummary.setForeground(headFG);
        this.chkSummary.setFont(headFont);
        this.lblSummary = this.actions.createJLabel(SUMMARY);
        this.lblSummary.setVisible(false);
        this.txtSummary = new JTextArea();
        this.txtSummary.setBackground(SystemColor.control);
        this.txtSummary.setLineWrap(true);
        this.txtSummary.setEditable(false);
        this.txtSummary.setRows(2);
        this.scrSummary = new CWScrollPane((Component)this.txtSummary);
        this.scrSummary.setVisible(false);
        this.btnGo = new JButton(this.actions.getAction(DONE));
        this.setBorder(BorderFactory.createLineBorder(SystemColor.control, 5));
        this.setLayout(new GridBagLayout());
        int gridy = 0;
        this.add((Component)this.lblHeading, new GridBagConstraints(0, ++gridy, 3, 1, 0.0, 0.0, 21, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.lblPhrase, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtPhrase, new GridBagConstraints(1, gridy, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.lblIncludes, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtIncludes, new GridBagConstraints(1, gridy, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.lblExcludes, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtExcludes, new GridBagConstraints(1, gridy, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.lblSpell, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtSpell, new GridBagConstraints(1, gridy, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.lblStartsWith, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtStartsWith, new GridBagConstraints(1, gridy, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.chkRank, new GridBagConstraints(0, ++gridy, 3, 1, 0.0, 0.0, 21, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.lblRank, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.sliderRank, new GridBagConstraints(1, gridy, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.chkRestrict, new GridBagConstraints(0, ++gridy, 3, 1, 0.0, 0.0, 21, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.lblPresets, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.cboPresets, new GridBagConstraints(1, gridy, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.lblRestrict, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtRestrict, new GridBagConstraints(1, gridy, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.btnRestrict, new GridBagConstraints(2, gridy, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.chkSummary, new GridBagConstraints(0, ++gridy, 3, 1, 0.0, 0.0, 21, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.lblSummary, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.scrSummary, new GridBagConstraints(1, gridy, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.btnGo, new GridBagConstraints(2, ++gridy, 1, 1, 0.0, 0.0, 15, 0, new Insets(10, 0, 5, 5), 0, 0));
        GuiUtil.applyDefaultOrientation((Component)this);
    }

    public String showInDialog(Component parent, String title, boolean modal, String search) {
        this.txtSummary.setText(search);
        Frame root = JOptionPane.getFrameForComponent(parent);
        this.dlgMain = new JDialog(root);
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
        this.bailout = true;
        ActionListener closer = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AdvancedSearchPane.this.dlgMain.dispose();
            }
        };
        this.dlgMain.getContentPane().setLayout(new BorderLayout());
        this.dlgMain.getContentPane().add((Component)this, "Center");
        this.dlgMain.getRootPane().setDefaultButton(this.btnGo);
        this.dlgMain.getRootPane().registerKeyboardAction(closer, esc, 2);
        this.dlgMain.setDefaultCloseOperation(2);
        this.dlgMain.setTitle(title);
        this.dlgMain.setModal(modal);
        GuiUtil.restrainedPack((Window)this.dlgMain, (float)0.5f, (float)0.75f);
        GuiUtil.centerWindow((Window)this.dlgMain);
        GuiUtil.applyDefaultOrientation((Component)this.dlgMain);
        this.dlgMain.setVisible(true);
        if (this.bailout) {
            return null;
        }
        return this.txtSummary.getText();
    }

    public boolean isRanked() {
        return this.chkRank.isSelected();
    }

    public final void setLabelRank(int val) {
        if (val == 0) {
            this.lblRank.setText(this.shaper.shape(Msg.RANK.toString("All")));
        } else if (val == 1) {
            this.lblRank.setText(this.shaper.shape(Msg.RANK_ONE.toString()));
        } else {
            this.lblRank.setText(this.shaper.shape(Msg.RANK.toString(new Integer(val))));
        }
    }

    public void doHeadRank() {
        boolean visible = this.chkRank.isSelected();
        this.lblRank.setVisible(visible);
        this.sliderRank.setVisible(visible);
        if (this.dlgMain != null) {
            this.dlgMain.pack();
        }
    }

    public void doHeadRestrict() {
        boolean visible = this.chkRestrict.isSelected();
        this.lblPresets.setVisible(visible);
        this.cboPresets.setVisible(visible);
        this.lblRestrict.setVisible(visible);
        this.txtRestrict.setVisible(visible);
        this.btnRestrict.setVisible(visible);
        if (this.dlgMain != null) {
            this.dlgMain.pack();
        }
    }

    public void doHeadSummary() {
        boolean visible = this.chkSummary.isSelected();
        this.lblSummary.setVisible(visible);
        this.scrSummary.setVisible(visible);
        if (this.dlgMain != null) {
            this.dlgMain.pack();
        }
    }

    public void doHeadOriginal() {
    }

    public void doHeadTime() {
    }

    public void doRestrictSelect() {
        String passg;
        if (this.dlgSelect == null) {
            this.dlgSelect = new PassageSelectionPane();
        }
        if ((passg = this.dlgSelect.showInDialog(this, Msg.ADVANCED_SELECT_TITLE.toString(), true, this.txtRestrict.getText())) != null) {
            this.cboPresets.setSelectedItem(this.presets[this.presets.length - 1]);
            this.txtRestrict.setText(passg);
        }
    }

    public void doDone() {
        this.bailout = false;
        this.dlgMain.dispose();
    }

    public final void updatePreset() {
        if (this.editingRestrict) {
            return;
        }
        String include = "";
        String preset = (String)this.cboPresets.getSelectedItem();
        if (preset != null) {
            int open = preset.indexOf(this.presetStart);
            int close = preset.indexOf(this.presetEnd);
            if (open != -1 && close != -1) {
                include = preset.substring(open + 1, close);
            }
        }
        this.txtRestrict.setText(include);
    }

    private void updateSearchString() {
        String startsWith;
        String spell;
        String excludes;
        String includes;
        String phrase;
        StringBuffer search = new StringBuffer();
        String restrict = this.txtRestrict.getText();
        if (restrict != null && restrict.trim().length() > 0) {
            if (search.length() != 0) {
                search.append(SPACE);
            }
            search.append(SearchType.RANGE.decorate(restrict));
        }
        if ((phrase = this.txtPhrase.getText()) != null && phrase.trim().length() > 0) {
            if (search.length() != 0) {
                search.append(SPACE);
            }
            search.append(SearchType.PHRASE.decorate(phrase));
        }
        if ((includes = this.txtIncludes.getText()) != null && includes.trim().length() > 0) {
            if (search.length() != 0) {
                search.append(SPACE);
            }
            search.append(SearchType.ALL_WORDS.decorate(includes));
        }
        if ((excludes = this.txtExcludes.getText()) != null && excludes.trim().length() > 0) {
            if (search.length() != 0) {
                search.append(SPACE);
            }
            search.append(SearchType.NOT_WORDS.decorate(excludes));
        }
        if ((spell = this.txtSpell.getText()) != null && spell.trim().length() > 0) {
            if (search.length() != 0) {
                search.append(SPACE);
            }
            search.append(SearchType.SPELL_WORDS.decorate(spell));
        }
        if ((startsWith = this.txtStartsWith.getText()) != null && startsWith.trim().length() > 0) {
            if (search.length() != 0) {
                search.append(SPACE);
            }
            search.append(SearchType.START_WORDS.decorate(startsWith));
        }
        this.txtSummary.setText(search.toString());
        this.editingRestrict = true;
        boolean match = false;
        ComboBoxModel model = this.cboPresets.getModel();
        String find = this.presetStart + restrict + this.presetEnd;
        for (int i = 0; !match && i < model.getSize(); ++i) {
            String element = (String)model.getElementAt(i);
            if (element.indexOf(find) == -1) continue;
            this.cboPresets.setSelectedIndex(i);
            match = true;
        }
        if (!match) {
            this.cboPresets.setSelectedItem(this.presets[this.presets.length - 1]);
        }
        this.editingRestrict = false;
    }

    public void changedUpdate(DocumentEvent ev) {
        this.updateSearchString();
    }

    public void insertUpdate(DocumentEvent ev) {
        this.updateSearchString();
    }

    public void removeUpdate(DocumentEvent ev) {
        this.updateSearchString();
    }

    private Dictionary createSliderLabels() {
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        int max = DisplaySelectPane.getMaxNumRankedVerses();
        for (int i = 0; i <= max; i += 20) {
            Integer label = new Integer(i);
            ((Dictionary)labels).put(label, new JLabel(this.shaper.shape(label.toString()), 0));
        }
        return labels;
    }
}

