/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing.desktop;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.desktop.AbstractViewLayout;
import org.crosswire.common.swing.desktop.Clearable;
import org.crosswire.common.swing.desktop.LayoutType;
import org.crosswire.common.swing.desktop.Titleable;
import org.crosswire.common.swing.desktop.ViewGenerator;
import org.crosswire.common.swing.desktop.ViewVisitor;
import org.crosswire.common.swing.desktop.Viewable;
import org.crosswire.common.swing.desktop.event.TitleChangedEvent;
import org.crosswire.common.swing.desktop.event.TitleChangedListener;
import org.crosswire.common.swing.desktop.event.ViewEvent;
import org.crosswire.common.swing.desktop.event.ViewEventListener;
import org.crosswire.common.util.CallContext;

public class ViewManager
implements Viewable,
TitleChangedListener,
ViewEventListener {
    public static final String TAB_MODE = "TabMode";
    public static final String WINDOW_MODE = "WindowMode";
    public static final String NEW_TAB = "NewTab";
    public static final String CLOSE_VIEW = "CloseView";
    public static final String CLEAR_VIEW = "ClearView";
    public static final String CLOSE_ALL_VIEWS = "CloseAllViews";
    public static final String CLOSE_OTHER_VIEWS = "CloseOtherViews";
    public static final String OPEN = "Open";
    public static final String SAVE = "Save";
    public static final String SAVE_AS = "SaveAs";
    public static final String SAVE_ALL = "SaveAll";
    private static LayoutType initial;
    private ViewGenerator generator;
    private JPanel panel;
    private LayoutType current;
    private ActionFactory contextActions;
    private JRadioButtonMenuItem tdiView;
    private JRadioButtonMenuItem mdiView;
    private GridBagConstraints gbc;

    public ViewManager(ViewGenerator generator) {
        this.generator = generator;
        this.panel = new JPanel(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.panel.add((Component)this.getViewLayout().getPanel(), this.getConstraint());
        this.contextActions = new ActionFactory(CallContext.getCallingClass(), this);
        this.tdiView = new JRadioButtonMenuItem(this.contextActions.getAction(TAB_MODE));
        this.mdiView = new JRadioButtonMenuItem(this.contextActions.getAction(WINDOW_MODE));
        ButtonGroup grpViews = new ButtonGroup();
        grpViews.add(this.mdiView);
        grpViews.add(this.tdiView);
        if (this.getViewLayoutType().equals(LayoutType.MDI)) {
            this.mdiView.setSelected(true);
        } else {
            this.tdiView.setSelected(true);
        }
        this.addViewEventListener(this);
        this.addView();
        GuiUtil.applyDefaultOrientation(this.panel);
    }

    public JPanel getDesktop() {
        return this.panel;
    }

    public JRadioButtonMenuItem getMdiView() {
        return this.mdiView;
    }

    public JRadioButtonMenuItem getTdiView() {
        return this.tdiView;
    }

    public final void addView(Component component) {
        this.getViewLayout().addView(component);
    }

    public void closeAll() {
        this.getViewLayout().closeAll();
    }

    public void closeOthers(Component component) {
        this.getViewLayout().closeOthers(component);
    }

    public Component getView(int i) {
        return this.getViewLayout().getView(i);
    }

    public Collection getViews() {
        return this.getViewLayout().getViews();
    }

    public void moveTo(AbstractViewLayout other) {
        this.getViewLayout().moveTo(other);
    }

    public void updateTitle(Component component) {
        this.getViewLayout().updateTitle(component);
    }

    public final Component addView() {
        Component view = this.generator.createView();
        if (view instanceof Titleable) {
            ((Titleable)((Object)view)).addTitleChangedListener(this);
        }
        this.addView(view);
        return view;
    }

    public void removeView(Component view) {
        if (this.getViewLayout().getViewCount() == 1) {
            if (view instanceof Clearable) {
                ((Clearable)((Object)view)).clear();
            }
            return;
        }
        this.getViewLayout().removeView(view);
    }

    public void clear(Component view) {
        if (view instanceof Clearable) {
            ((Clearable)((Object)view)).clear();
        }
    }

    public Iterator iterator() {
        return this.getViewLayout().iterator();
    }

    public void visit(ViewVisitor visitor) {
        this.getViewLayout().visit(visitor);
    }

    public int getViewCount() {
        return this.getViewLayout().getViewCount();
    }

    public Component getSelected() {
        return this.getViewLayout().getSelected();
    }

    public void select(Component component) {
        this.getViewLayout().select(component);
    }

    private static LayoutType getInitialViewLayoutType() {
        if (initial == null) {
            initial = LayoutType.TDI;
        }
        return initial;
    }

    private LayoutType getViewLayoutType() {
        if (this.current == null) {
            this.current = ViewManager.getInitialViewLayoutType();
        }
        return this.current;
    }

    private void setViewLayoutType(LayoutType newLayoutType) {
        this.current = newLayoutType;
    }

    public final AbstractViewLayout getViewLayout() {
        return this.getViewLayoutType().getLayout();
    }

    public void setLayoutType(LayoutType next) {
        if (this.getViewLayoutType().equals(next)) {
            return;
        }
        AbstractViewLayout nextLayout = next.getLayout();
        AbstractViewLayout currentLayout = this.getViewLayout();
        currentLayout.moveTo(nextLayout);
        this.panel.remove(currentLayout.getPanel());
        this.panel.add((Component)nextLayout.getPanel(), this.getConstraint());
        this.setViewLayoutType(next);
    }

    public static int getInitialLayoutType() {
        if (initial == null) {
            initial = LayoutType.TDI;
        }
        return initial.toInteger();
    }

    public void viewRemoved(ViewEvent event) {
        Object view = event.getSource();
        if (view instanceof Titleable) {
            ((Titleable)view).removeTitleChangedListener(this);
        }
    }

    public static void setInitialLayoutType(int initialLayout) {
        initial = LayoutType.fromInteger(initialLayout);
    }

    public void titleChanged(TitleChangedEvent ev) {
        Component view = (Component)ev.getSource();
        this.getViewLayout().updateTitle(view);
    }

    public final void addViewEventListener(ViewEventListener listener) {
        LayoutType.MDI.getLayout().addViewEventListener(listener);
        LayoutType.TDI.getLayout().addViewEventListener(listener);
    }

    public void removeViewEventListener(ViewEventListener listener) {
        LayoutType.MDI.getLayout().removeViewEventListener(listener);
        LayoutType.TDI.getLayout().removeViewEventListener(listener);
    }

    public Action getContextAction(String key) {
        return this.contextActions.getAction(key);
    }

    final Object getConstraint() {
        return this.gbc;
    }

    public void doTabMode() {
        this.setLayoutType(LayoutType.TDI);
    }

    public void doWindowMode() {
        this.setLayoutType(LayoutType.MDI);
    }

    public void doNewTab() {
        this.addView();
    }

    public void doCloseView() {
        this.removeView(this.getSelected());
    }

    public void doClearView() {
        this.clear(this.getSelected());
    }

    public void doCloseAllViews() {
        this.closeAll();
    }

    public void doCloseOtherViews() {
        this.closeOthers(this.getSelected());
    }
}

