/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.Dimension;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.MappedChoice;
import org.crosswire.common.config.swing.Field;
import org.crosswire.common.config.swing.Msg;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.MapComboBoxModel;
import org.crosswire.common.swing.MapEntryRenderer;
import org.crosswire.common.util.Logger;

public class MappedOptionsField
implements Field {
    private JComboBox combo = new JComboBox<String>(new String[]{Msg.NO_OPTIONS.toString()});
    private static final Logger log = Logger.getLogger((Class)MappedOptionsField.class);

    public MappedOptionsField() {
        this.combo.setPreferredSize(new Dimension(100, this.combo.getPreferredSize().height));
        GuiUtil.applyDefaultOrientation(this.combo);
    }

    public void setChoice(Choice param) {
        if (!(param instanceof MappedChoice)) {
            throw new IllegalArgumentException("Illegal type for Choice. Not a MappedChoice. " + param.getKey());
        }
        MappedChoice mc = (MappedChoice)param;
        Map map = mc.getOptions();
        if (map == null) {
            throw new IllegalArgumentException("getOptions() returns null for option: " + param.getKey());
        }
        this.combo.setModel(new MapComboBoxModel(map));
        this.combo.setRenderer(new MapEntryRenderer());
    }

    public String getValue() {
        Object reply = this.combo.getSelectedItem();
        if (reply instanceof Map.Entry) {
            return ((Map.Entry)reply).getKey().toString();
        }
        return reply == null ? "" : reply.toString();
    }

    public void setValue(String value) {
        ComboBoxModel model = this.combo.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            Map.Entry mapEntry;
            Object match = model.getElementAt(i);
            if (!(match instanceof Map.Entry) || !(mapEntry = (Map.Entry)match).getKey().toString().equals(value) && !mapEntry.getValue().toString().equals(value)) continue;
            this.combo.setSelectedItem(mapEntry);
            return;
        }
        Object selected = this.combo.getSelectedItem();
        if (value.length() > 0 && selected != null) {
            log.warn("Checked for options without finding: '" + value + "'. Defaulting to first option: " + selected);
        }
    }

    public JComponent getComponent() {
        return this.combo;
    }
}

